<?php
include 'db.php'; // Your DB connection

$office_name = "COLLATE ENTERPRISES";
$office_mobile = "+255 712 345 678";

// ===== Handle form submissions =====

// Assign new fundi
if(isset($_POST['assign'])){
    $project_id = intval($_POST['project_id']);
    $worker_name = $_POST['worker_name'];
    $task = $_POST['task'];
    $agreed_amount = floatval($_POST['agreed_amount']);

    $stmt = $conn->prepare("INSERT INTO assignments (project_id, worker_name, task, agreed_amount) VALUES (?,?,?,?)");
    $stmt->bind_param("issi", $project_id, $worker_name, $task, $agreed_amount);
    $stmt->execute();
    $stmt->close();
    header("Location: assignments.php");
    exit;
}

// Update progress
if(isset($_POST['update_progress'])){
    $id = intval($_POST['id']);
    $progress = intval($_POST['progress']);
    $stmt = $conn->prepare("UPDATE assignments SET progress=? WHERE id=?");
    $stmt->bind_param("ii",$progress,$id);
    $stmt->execute();
    $stmt->close();
    header("Location: assignments.php");
    exit;
}

// Make payment
if(isset($_POST['make_payment'])){
    $id = intval($_POST['id']);
    $amount = floatval($_POST['amount']);
    $reference = !empty($_POST['reference']) ? $_POST['reference'] : "CASH";

    $stmt = $conn->prepare("UPDATE assignments SET amount_paid = amount_paid + ? WHERE id=?");
    $stmt->bind_param("di",$amount,$id);
    $stmt->execute();
    $stmt->close();

    // Optionally generate receipt here (FPDF or similar)
    header("Location: assignments.php");
    exit;
}

// Delete assignment
if(isset($_POST['delete_assignment'])){
    $id = intval($_POST['id']);
    $stmt = $conn->prepare("DELETE FROM assignments WHERE id=?");
    $stmt->bind_param("i",$id);
    $stmt->execute();
    $stmt->close();
    header("Location: assignments.php");
    exit;
}

// Fetch assignments
$assignments = $conn->query("SELECT a.*, p.name AS project_name FROM assignments a LEFT JOIN projects p ON a.project_id=p.id");

?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Assignments</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<style>
body { background:#f8f9fa; }
.container { margin-top:40px; }
.table th, .table td { vertical-align: middle; }
.dropdown-toggle::after { display:none; }
</style>
</head>
<body>
<div class="container">
<h2 class="mb-4">Project Assignments</h2>

<!-- Assign Fundi Form -->
<div class="card mb-4">
<div class="card-header">Assign a Fundi</div>
<div class="card-body">
<form method="post" class="row g-2">
<div class="col-md-2"><input type="number" name="project_id" class="form-control" placeholder="Project ID" required></div>
<div class="col-md-2"><input type="text" name="worker_name" class="form-control" placeholder="Fundi Name" required></div>
<div class="col-md-3"><input type="text" name="task" class="form-control" placeholder="Task" required></div>
<div class="col-md-2"><input type="number" step="0.01" name="agreed_amount" class="form-control" placeholder="Agreed Amount" required></div>
<div class="col-md-3"><button type="submit" name="assign" class="btn btn-primary w-100">Assign</button></div>
</form>
</div>
</div>

<!-- Assignments Table -->
<div class="card">
<div class="card-header">Assignments List</div>
<div class="card-body table-responsive">
<table class="table table-bordered table-hover align-middle">
<thead class="table-dark">
<tr>
<th>#</th>
<th>Project</th>
<th>Fundi</th>
<th>Task</th>
<th>Agreed Amount</th>
<th>Paid</th>
<th>Balance</th>
<th>Progress</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php
if($assignments->num_rows>0){
    $sn=1;
    while($a=$assignments->fetch_assoc()){
        $balance=$a['agreed_amount']-$a['amount_paid'];
        ?>
<tr>
<td><?= $sn++; ?></td>
<td><?= htmlspecialchars($a['project_name']) ?> (#<?= $a['project_id'] ?>)</td>
<td><?= htmlspecialchars($a['worker_name']) ?></td>
<td><?= htmlspecialchars($a['task']) ?></td>
<td>Tshs. <?= number_format($a['agreed_amount'],2) ?></td>
<td>Tshs. <?= number_format($a['amount_paid'],2) ?></td>
<td>Tshs. <?= number_format($balance,2) ?></td>
<td><?= $a['progress'] ?>%</td>
<td>
<div class="dropdown">
<button type="button" class="btn btn-light btn-sm border-0" data-bs-toggle="dropdown">&#8942;</button>
<ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#progressModal<?= $a['id'] ?>">Update Progress</a></li>
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#payModal<?= $a['id'] ?>">Make Payment</a></li>
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#viewModal<?= $a['id'] ?>">View</a></li>
<li><a class="dropdown-item text-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?= $a['id'] ?>">Delete</a></li>
</ul>
</div>
</td>
</tr>

<!-- Progress Modal -->
<div class="modal fade" id="progressModal<?= $a['id'] ?>" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<form method="post" action="" class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Update Progress</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<input type="number" name="progress" class="form-control" placeholder="Progress %" required>
</div>
<div class="modal-footer">
<button type="submit" name="update_progress" class="btn btn-primary">Update</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</form>
</div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="payModal<?= $a['id'] ?>" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<form method="post" action="" class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Make Payment</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<p>Do you really want to make this payment? Current Balance: Tshs. <?= number_format($balance,2) ?></p>
<input type="number" step="0.01" name="amount" class="form-control mb-2" placeholder="Amount" required>
<input type="text" name="reference" class="form-control" placeholder="Reference (or leave blank for Cash)">
</div>
<div class="modal-footer">
<button type="submit" name="make_payment" class="btn btn-success">Pay</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</form>
</div>
</div>

<!-- View Modal -->
<div class="modal fade" id="viewModal<?= $a['id'] ?>" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Assignment Details</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<p><strong>Project:</strong> <?= htmlspecialchars($a['project_name']) ?> (#<?= $a['project_id'] ?>)</p>
<p><strong>Fundi:</strong> <?= htmlspecialchars($a['worker_name']) ?></p>
<p><strong>Task:</strong> <?= htmlspecialchars($a['task']) ?></p>
<p><strong>Agreed Amount:</strong> Tshs. <?= number_format($a['agreed_amount'],2) ?></p>
<p><strong>Paid:</strong> Tshs. <?= number_format($a['amount_paid'],2) ?></p>
<p><strong>Balance:</strong> Tshs. <?= number_format($balance,2) ?></p>
<p><strong>Progress:</strong> <?= $a['progress'] ?>%</p>
</div>
<div class="modal-footer">
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal<?= $a['id'] ?>" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<form method="post" action="<?= $_SERVER['PHP_SELF'] ?>" class="modal-content">
<div class="modal-header">
<h5 class="modal-title text-danger">Delete Assignment</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<p>Are you sure you want to delete this assignment?</p>
</div>
<div class="modal-footer">
<button type="submit" name="delete_assignment" class="btn btn-danger">Delete</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</form>
</div>
</div>

<?php
    }
}else{
    echo "<tr><td colspan='9' class='text-center'>No assignments found</td></tr>";
}
?>
</tbody>
</table>
</div>
</div>

<div class="text-center mt-4">
<a href="index.php" class="btn btn-primary">Home</a>
</div>
</div>
</body>
</html>
